# Début programme de pilotage SmartLED/NeoPixel - Matrice LED 5x5
# Matrice LED connecté sur D2

# Aka NeoPixels
# Aka WS2812 and others
# Sciencethic 651 050

from time import sleep

# Nous importons le seul élément Arduino de pyfirmata2Ext
from pyfirmata2Ext import Arduino

################################
# Communication avec Plug'Uno
################################
# Instanciation d'un objet représentant la carte Plug'Uino Uno.
# Arduino.AUTODETECT peut être remplacé par l'identifiant de port-série (ex : "COM1").
# Arduino.AUTODETECT peut ne pas fonctionner correctement avec les port-série Bluetooth.
plugUno = Arduino(Arduino.AUTODETECT)

################################
# Utilisation
################################

# Dans cette exemple la matrice est connecté a D2
brocheMatriceLED = 2

# Définir la couleur d'une LED à 3 canaux Rouge - Vert - Bleu
# -> DEL à 4 canaux : Vert - Rouge - Bleu - Blanc
# Chaque canal doit être representé par 1 octet.
# -> 3 octets par LED

# Notre matrice DEL est composé de 25 DELs (5x5)

# -> Nous avons besoin d'une memoire tampon de 25 * 3 octets
# -> tableau de 75 octet initialisé a 0x00
pixels = [0] * 75

# Initialise a matrice DEL avec toutes led DEL éteintes
plugUno.writeSmartLED(brocheMatriceLED , pixels)

sleep(3)

#####################################################
# Active les sous-pixels un à un

for indexPixelRouge in range(0,25*3,3):
    pixels = [0] * 75
    pixels[indexPixelRouge] = 100
    plugUno.writeSmartLED(brocheMatriceLED , pixels)
    sleep(0.04)

for indexPixelVert in range(1,25*3,3):
    pixels = [0] * 75
    pixels[indexPixelVert] = 100
    plugUno.writeSmartLED(brocheMatriceLED , pixels)
    sleep(0.04)

for indexPixelBleu in range(2,25*3,3):
    pixels = [0] * 75
    pixels[indexPixelBleu] = 100
    plugUno.writeSmartLED(brocheMatriceLED , pixels)
    sleep(0.04)


#####################################################
# Boucle pour affecter les valeurs R, V, B sur toute la matrice
for niveauDeRouge in range(100) :
    pixels = [0] * 75
    for indexPixelRouge in range(0,25*3,3):
        pixels[indexPixelRouge] = niveauDeRouge
    plugUno.writeSmartLED(brocheMatriceLED , pixels)
    sleep(0.02)
        
for niveauDeVert in range(100) :
    pixels = [0] * 75
    for indexPixelVert in range(1,25*3,3):
        pixels[indexPixelVert] = niveauDeVert
    plugUno.writeSmartLED(brocheMatriceLED , pixels)
    sleep(0.02)
        
for niveauDeBleu in range(100) :
    pixels = [0] * 75
    for indexPixelBleu in range(2,25*3,3):
        pixels[indexPixelBleu] = niveauDeBleu
    plugUno.writeSmartLED(brocheMatriceLED , pixels)
    sleep(0.02)


# Eteindre toute les LED de la matrice avant de quitter
plugUno.writeSmartLED(brocheMatriceLED , [0] * 75)

# Fermer la connexion à Plug'Uno avant de quitter.
plugUno.exit()

# Termine l'éxecution du programme Python.
#exit()

# Fin programme de pilotage SmartLED/NeoPixel - Matrice LED 5x5
